<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('settings', $version_num);
	bodyNavigation('settings');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Manage</p>
	</div>
</div>

<div id="main-copy">

	<?php
	/*
	 * If the user has successfully made a change, show him the message.
	 */
	 if (isset($_SESSION['changesuccess'])) { ?>
		<br />
		<span class='changeSettingMessage'>
			<?php echo $_SESSION['changesuccess']; unset($_SESSION['changesuccess']); ?>
		</span>
	<?php } ?>

	<?php
		if ($_SERVER['QUERY_STRING'] == 'settings') {
			include("./includes/settings.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'channels') {
			include("./includes/channels.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'logs') {
			include("./includes/logs.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'accounts') {
			include("./includes/accounts.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'info') {
			include("./includes/info.php");
		} else {
			include("./includes/settings.php");
		}
	?>


</div>

<?php bodyFooter('settings', $start_time); ?>